/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWEventDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWRollbackInstruction;
import filenet.vw.api.VWSimpleInstruction;
import filenet.vw.api.VWWFEInstruction;
import filenet.vw.base.VWDebug;

public class VWInstruction {
    public static void AssignInstructionSetAssignment(VWInstructionDefinition instructionDef, String[][] assignments) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 0) {
                int assignmentCount;
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                if (assignments != null && (assignmentCount = assignments.length) >= 0) {
                    String[] newParams = new String[assignmentCount * 2];
                    for (int i = 0; i < assignmentCount; ++i) {
                        newParams[i * 2] = assignments[i][0];
                        newParams[i * 2 + 1] = assignments[i][1];
                    }
                    instruction.setParams(newParams);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String[][] AssignInstructionGetAssignment(VWInstructionDefinition instructionDef) {
        int paramCount;
        VWSimpleInstruction instruction;
        String[] params;
        String[][] assignments = null;
        if (instructionDef != null && instructionDef.getAction() == 0 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && (paramCount = params.length) > 0) {
            assignments = new String[paramCount / 2][2];
            for (int i = 0; i < paramCount; ++i) {
                assignments[i / 2][0] = params[i];
                assignments[i / 2][1] = params[++i];
            }
        }
        return assignments;
    }

    public static void BeginTimerInstructionSetName(VWInstructionDefinition instructionDef, String name) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 1) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length == 0) {
                    params = new String[]{name};
                }
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static void BeginTimerInstructionSetExpirationTime(VWInstructionDefinition instructionDef, String time) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 1) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length < 2) {
                    params = new String[2];
                }
                params[1] = time;
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static void BeginTimerInstructionSetSubmapName(VWInstructionDefinition instructionDef, String submap) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 1) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length < 3) {
                    params = new String[3];
                }
                params[2] = submap;
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String BeginTimerInstructionGetName(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String name = null;
        if (instructionDef != null && instructionDef.getAction() == 1 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            name = params[0];
        }
        return name;
    }

    public static String BeginTimerInstructionGetExpirationTime(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String time = null;
        if (instructionDef != null && instructionDef.getAction() == 1 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            time = params[1];
        }
        return time;
    }

    public static String BeginTimerInstructionGetSubmapName(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String submap = null;
        if (instructionDef != null && instructionDef.getAction() == 1 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            submap = params[2];
        }
        return submap;
    }

    public static void CallInstructionSetSubmap(VWInstructionDefinition instructionDef, String submapName) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 5) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length == 0) {
                    params = new String[]{submapName};
                }
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String CallInstructionGetSubmap(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String submapName = null;
        if (instructionDef != null && instructionDef.getAction() == 5 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            submapName = params[0];
        }
        return submapName;
    }

    public static void CreateInstructionSetWorkClass(VWInstructionDefinition instructionDef, String workclass) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 6) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length == 0) {
                    params = new String[]{workclass};
                }
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static void CreateInstructionSetAssignments(VWInstructionDefinition instructionDef, String[][] assignments) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 6) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                int assignmentCount = assignments.length;
                if (assignmentCount >= 0) {
                    String[] newParams = new String[assignmentCount * 2 + 1];
                    newParams[0] = params[0];
                    for (int i = 0; i < assignmentCount; ++i) {
                        int difference = i + 1;
                        newParams[difference + i] = assignments[i][0];
                        newParams[difference + 1 + i] = assignments[i][1];
                    }
                    instruction.setParams(newParams);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String CreateInstructionGetWorkClass(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String workClass = null;
        if (instructionDef != null && instructionDef.getAction() == 6 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            workClass = params[0];
        }
        return workClass;
    }

    public static String[][] CreateInstructionGetAssignments(VWInstructionDefinition instructionDef) {
        int paramCount;
        VWSimpleInstruction instruction;
        String[] params;
        String[][] assignments = null;
        if (instructionDef != null && instructionDef.getAction() == 6 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && (paramCount = params.length) > 1) {
            int assignmentCount = (paramCount - 1) / 2;
            assignments = new String[assignmentCount][2];
            for (int i = 0; i < assignmentCount; ++i) {
                int difference = i + 1;
                assignments[i][0] = params[difference + i];
                assignments[i][1] = params[difference + i + 1];
            }
        }
        return assignments;
    }

    public static void DatabaseExecuteInstructionSetDatabaseName(VWInstructionDefinition instructionDef, String dbName) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 37) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length == 0) {
                    params = new String[]{dbName};
                }
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String DatabaseExecuteInstructionGetDatabaseName(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String dbName = null;
        if (instructionDef != null && instructionDef.getAction() == 37 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            dbName = params[0];
        }
        return dbName;
    }

    public static void DatabaseExecuteInstructionSetStoredProcName(VWInstructionDefinition instructionDef, String storedProcName) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 37) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length < 2) {
                    params = new String[2];
                }
                params[1] = storedProcName;
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String DatabaseExecuteInstructionGetStoredProcName(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String storedProcName = null;
        if (instructionDef != null && instructionDef.getAction() == 37 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            storedProcName = params[1];
        }
        return storedProcName;
    }

    public static void DatabaseExecuteInstructionSetParameters(VWInstructionDefinition instructionDef, String[] expressions) {
        try {
            int expressionsCount;
            VWSimpleInstruction instruction;
            String[] params;
            if (instructionDef != null && instructionDef.getAction() == 37 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0 && (expressionsCount = expressions.length) >= 0) {
                String[] newParams = new String[expressionsCount + 2];
                newParams[0] = params[0];
                newParams[1] = params[1];
                for (int i = 0; i < expressionsCount; ++i) {
                    newParams[i + 2] = expressions[i];
                }
                instruction.setParams(newParams);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String[] DatabaseExecuteInstructionGetParameters(VWInstructionDefinition instructionDef) {
        int paramCount;
        VWSimpleInstruction instruction;
        String[] params;
        String[] expressions = null;
        if (instructionDef != null && instructionDef.getAction() == 37 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0 && (paramCount = params.length) > 1) {
            int expressionsCount = paramCount - 2;
            expressions = new String[expressionsCount];
            for (int i = 0; i < expressionsCount; ++i) {
                expressions[i] = params[i + 2];
            }
        }
        return expressions;
    }

    public static void DelayInstructionSetTime(VWInstructionDefinition instructionDef, String time) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 7) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length == 0) {
                    params = new String[]{time};
                }
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String DelayInstructionGetTime(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String time = null;
        if (instructionDef != null && instructionDef.getAction() == 7 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            time = params[0];
        }
        return time;
    }

    public static void EndTimerInstructionSetTime(VWInstructionDefinition instructionDef, String time) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 9) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length == 0) {
                    params = new String[]{time};
                }
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String EndTimerInstructionGetTime(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String time = null;
        if (instructionDef != null && instructionDef.getAction() == 9 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            time = params[0];
        }
        return time;
    }

    public static String ExecuteInstructionGetQueueName(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String queueName = null;
        if (instructionDef != null && instructionDef.getAction() == 23 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            queueName = params[0];
        }
        return queueName;
    }

    public static void ExecuteInstructionSetQueueName(VWInstructionDefinition instructionDef, String queueName) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 23) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length == 0) {
                    params = new String[]{queueName};
                }
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String ExecuteInstructionGetOperationName(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String operationName = null;
        if (instructionDef != null && instructionDef.getAction() == 23 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            operationName = params[1];
        }
        return operationName;
    }

    public static void ExecuteInstructionSetOperationName(VWInstructionDefinition instructionDef, String operationName) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 23) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length < 2) {
                    params = new String[2];
                }
                params[1] = operationName;
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String[] ExecuteInstructionGetParameterList(VWInstructionDefinition instructionDef) {
        int paramCount;
        VWSimpleInstruction instruction;
        String[] params;
        String[] paramList = null;
        if (instructionDef != null && instructionDef.getAction() == 23 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0 && (paramCount = params.length) > 1) {
            int nActualParameterCount = paramCount - 2;
            paramList = new String[nActualParameterCount];
            for (int i = 0; i < nActualParameterCount; ++i) {
                paramList[i] = params[i + 2];
            }
        }
        return paramList;
    }

    public static void ExecuteInstructionSetParameterList(VWInstructionDefinition instructionDef, String[] paramList) {
        try {
            int nParameterCount;
            VWSimpleInstruction instruction;
            String[] params;
            if (instructionDef != null && instructionDef.getAction() == 23 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0 && (nParameterCount = paramList.length) >= 0) {
                String[] newParams = new String[nParameterCount + 2];
                newParams[0] = params[0];
                newParams[1] = params[1];
                for (int i = 0; i < nParameterCount; ++i) {
                    newParams[i + 2] = paramList[i];
                }
                instruction.setParams(newParams);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static void LogInstructionSetEventType(VWInstructionDefinition instructionDef, String eventType) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 38) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length == 0) {
                    params = new String[]{eventType};
                }
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String LogInstructionGetEventType(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String eventType = null;
        if (instructionDef != null && instructionDef.getAction() == 38 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            eventType = params[0];
        }
        return eventType;
    }

    public static void LogInstructionSetEventMessage(VWInstructionDefinition instructionDef, String msg) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 38) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length < 2) {
                    params = new String[2];
                }
                params[1] = msg;
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String LogInstructionGetEventMessage(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String msg = null;
        if (instructionDef != null && instructionDef.getAction() == 38 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            msg = params[1];
        }
        return msg;
    }

    public static void ResumeTimerInstructionSetTime(VWInstructionDefinition instructionDef, String time) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 13) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length == 0) {
                    params = new String[]{time};
                }
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String ResumeTimerInstructionGetTime(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String time = null;
        if (instructionDef != null && instructionDef.getAction() == 13 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            time = params[0];
        }
        return time;
    }

    public static void ReturnInstructionSetRetryOption(VWInstructionDefinition instructionDef, String retryOption) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 14) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length == 0) {
                    params = new String[]{retryOption};
                }
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String ReturnInstructionGetRetryOption(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String retryOption = null;
        if (instructionDef != null && instructionDef.getAction() == 14 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            retryOption = params[0];
        }
        return retryOption;
    }

    public static void RollBackCheckPointInstructionSetReDoFlag(VWInstructionDefinition instructionDef, String reDoFlag) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 29 && instructionDef instanceof VWRollbackInstruction) {
                ((VWRollbackInstruction)instructionDef).setReDo(reDoFlag);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static void RollBackCheckPointInstructionSetMap(VWInstructionDefinition instructionDef, String map) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 29 && instructionDef instanceof VWRollbackInstruction) {
                ((VWRollbackInstruction)instructionDef).setCompCall(map);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static void RollBackCheckPointInstructionSetNonRolledBackFieldList(VWInstructionDefinition instructionDef, String[] fieldList) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 29 && instructionDef instanceof VWRollbackInstruction) {
                ((VWRollbackInstruction)instructionDef).setParams(fieldList);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String RollBackCheckPointInstructionGetReDoFlag(VWInstructionDefinition instructionDef) {
        String reDoFlag = null;
        if (instructionDef != null && instructionDef.getAction() == 29 && instructionDef instanceof VWRollbackInstruction) {
            reDoFlag = ((VWRollbackInstruction)instructionDef).getReDo();
        }
        return reDoFlag;
    }

    public static String RollBackCheckPointInstructionGetMap(VWInstructionDefinition instructionDef) {
        String mapName = null;
        if (instructionDef != null && instructionDef.getAction() == 29 && instructionDef instanceof VWRollbackInstruction) {
            mapName = ((VWRollbackInstruction)instructionDef).getCompCall();
        }
        return mapName;
    }

    public static String[] RollBackCheckPointInstructionGetNonRolledBackFieldList(VWInstructionDefinition instructionDef) {
        String[] fieldList = null;
        if (instructionDef != null && instructionDef.getAction() == 29 && instructionDef instanceof VWRollbackInstruction) {
            fieldList = ((VWRollbackInstruction)instructionDef).getParams();
        }
        return fieldList;
    }

    public static void SuspendTimerInstructionSetTime(VWInstructionDefinition instructionDef, String time) {
        try {
            if (instructionDef != null && instructionDef.getAction() == 16) {
                VWSimpleInstruction instruction = (VWSimpleInstruction)instructionDef;
                String[] params = instruction.getParams();
                if (params == null || params.length == 0) {
                    params = new String[]{time};
                }
                instruction.setParams(params);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String SuspendTimerInstructionGetTime(VWInstructionDefinition instructionDef) {
        VWSimpleInstruction instruction;
        String[] params;
        String time = null;
        if (instructionDef != null && instructionDef.getAction() == 16 && (params = (instruction = (VWSimpleInstruction)instructionDef).getParams()) != null && params.length > 0) {
            time = params[0];
        }
        return time;
    }

    public static void WaitForEventInstructionSetTimeOut(VWInstructionDefinition instructionDef, String timeout) {
        try {
            if (instructionDef != null && instructionDef instanceof VWWFEInstruction) {
                ((VWWFEInstruction)instructionDef).setTimeOut(timeout);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String WaitForEventInstructionGetTimeOut(VWInstructionDefinition instructionDef) {
        if (instructionDef != null && instructionDef instanceof VWWFEInstruction) {
            return ((VWWFEInstruction)instructionDef).getTimeOut();
        }
        return null;
    }

    public static void WaitForEventInstructionSetEventNumLoc(VWInstructionDefinition instructionDef, String loc) {
        try {
            if (instructionDef != null && instructionDef instanceof VWWFEInstruction) {
                ((VWWFEInstruction)instructionDef).setEventNumLoc(loc);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static String WaitForEventInstructionGetEventNumLoc(VWInstructionDefinition instructionDef) {
        if (instructionDef != null && instructionDef instanceof VWWFEInstruction) {
            return ((VWWFEInstruction)instructionDef).getEventNumLoc();
        }
        return null;
    }

    public static VWEventDefinition WaitForEventInstructionCreateEvent(VWInstructionDefinition instructionDef) {
        try {
            if (instructionDef != null && instructionDef instanceof VWWFEInstruction) {
                return ((VWWFEInstruction)instructionDef).createEvent("", "=", "");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public static VWEventDefinition[] WaitForEventInstructionGetEvents(VWInstructionDefinition instructionDef) {
        try {
            if (instructionDef != null && instructionDef instanceof VWWFEInstruction) {
                return ((VWWFEInstruction)instructionDef).getEvents();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public static void WaitForEventInstructionSetEvents(VWInstructionDefinition instructionDef, VWEventDefinition[] eventDefs) {
        try {
            if (instructionDef != null && instructionDef instanceof VWWFEInstruction) {
                VWWFEInstruction wfeInstruction = (VWWFEInstruction)instructionDef;
                wfeInstruction.setEvents(eventDefs);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

